// Pseudo depth-of-field implementation for Minecraft by daxnitro.

uniform sampler2D sampler0;
uniform sampler2D sampler1;
uniform sampler2D sampler2;

uniform float aspectRatio;
uniform float near;
uniform float far;

const float dofSpan = 35.0;
const float blurMagnitude = 0.005;

float getDepth(vec2 coord);
float getCursorDepth(vec2 coord);
vec4 getSampleWithBoundsCheck(vec2 offset);

float samples = 0.0;
vec2 space;

void main() {
	vec4 baseColor = texture2D(sampler0, gl_TexCoord[0].st);

	float depth = getDepth(gl_TexCoord[0].st);

	if (depth >= far) {
		// Skybox.
		gl_FragColor = baseColor;		
		return;
	}

	float cursorDepth = getCursorDepth(vec2(0.5, 0.5));

	float blurAmount = clamp(abs(depth - cursorDepth) / dofSpan, 0.0, 1.0);

	if (blurAmount == 0.0) {
		gl_FragColor = baseColor;		
		return;
	}

	vec4 blurredColor = vec4(0.0);
	vec2 aspectCorrection = vec2(1.0, aspectRatio) * blurMagnitude;

	// This blur is pretty straight from this guy's shader: http://artmartinsh.blogspot.com/2010/02/glsl-lens-blur-filter-with-bokeh.html
	// You could probably cut some of this out (and update the division below) to get higher performance with little noticeable difference.
	
	blurredColor += texture2D(sampler0, gl_TexCoord[0].st);
	
	vec2 ac0_4 = 0.4 * aspectCorrection;	// 0.4
	vec2 ac0_4x0_4 = 0.4 * ac0_4;			// 0.16
	vec2 ac0_4x0_7 = 0.7 * ac0_4;			// 0.28
	
	vec2 ac0_29 = 0.29 * aspectCorrection;	// 0.29
	vec2 ac0_29x0_7 = 0.7 * ac0_29;			// 0.203
	vec2 ac0_29x0_4 = 0.4 * ac0_29;			// 0.116
	
	vec2 ac0_15 = 0.15 * aspectCorrection;	// 0.15
	vec2 ac0_37 = 0.37 * aspectCorrection;	// 0.37
	vec2 ac0_15x0_9 = 0.9 * ac0_15;			// 0.135
	vec2 ac0_37x0_9 = 0.37 * ac0_37;		// 0.1369
	
	vec2 lowSpace = gl_TexCoord[0].st;
	vec2 highSpace = 1.0 - lowSpace;
	space = vec2(min(lowSpace.s, highSpace.s), min(lowSpace.t, highSpace.t));
	
	if (space.s >= ac0_4.s && space.t >= ac0_4.t) {
		
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(0.0, ac0_4.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_4.s, 0.0));   
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(0.0, -ac0_4.t)); 
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_4.s, 0.0)); 
		
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_4x0_7.s, 0.0));       
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(0.0, -ac0_4x0_7.t));     
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_4x0_7.s, 0.0));     
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(0.0, ac0_4x0_7.t));
	
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_4x0_4.s, 0.0));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(0.0, -ac0_4x0_4.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_4x0_4.s, 0.0));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(0.0, ac0_4x0_4.t));

		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_29.s, -ac0_29.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_29.s, ac0_29.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_29.s, ac0_29.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_29.s, -ac0_29.t));
	
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_29x0_7.s, ac0_29x0_7.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_29x0_7.s, -ac0_29x0_7.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_29x0_7.s, ac0_29x0_7.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_29x0_7.s, -ac0_29x0_7.t));
		
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_29x0_4.s, ac0_29x0_4.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_29x0_4.s, -ac0_29x0_4.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_29x0_4.s, ac0_29x0_4.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_29x0_4.s, -ac0_29x0_4.t));
		
		
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_15.s, ac0_37.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_37.s, ac0_15.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_37.s, -ac0_15.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_15.s, -ac0_37.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_15.s, ac0_37.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_37.s, ac0_15.t)); 
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_37.s, -ac0_15.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_15.s, -ac0_37.t));
		
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_15x0_9.s, ac0_37x0_9.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_37x0_9.s, ac0_15x0_9.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_37x0_9.s, -ac0_15x0_9.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_15x0_9.s, -ac0_37x0_9.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_15x0_9.s, ac0_37x0_9.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_37x0_9.s, ac0_15x0_9.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(-ac0_37x0_9.s, -ac0_15x0_9.t));
		blurredColor += texture2D(sampler0, gl_TexCoord[0].st + vec2(ac0_15x0_9.s, -ac0_37x0_9.t));

	    blurredColor /= 41.0;
	    
	} else {
		
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, ac0_4.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_4.s, 0.0));   
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, -ac0_4.t)); 
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_4.s, 0.0)); 
		
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_4x0_7.s, 0.0));       
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, -ac0_4x0_7.t));     
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_4x0_7.s, 0.0));     
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, ac0_4x0_7.t));
	
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_4x0_4.s, 0.0));
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, -ac0_4x0_4.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_4x0_4.s, 0.0));
		blurredColor += getSampleWithBoundsCheck(vec2(0.0, ac0_4x0_4.t));

		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29.s, -ac0_29.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29.s, ac0_29.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29.s, ac0_29.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29.s, -ac0_29.t));
	
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29x0_7.s, ac0_29x0_7.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29x0_7.s, -ac0_29x0_7.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29x0_7.s, ac0_29x0_7.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29x0_7.s, -ac0_29x0_7.t));
		
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29x0_4.s, ac0_29x0_4.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_29x0_4.s, -ac0_29x0_4.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29x0_4.s, ac0_29x0_4.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_29x0_4.s, -ac0_29x0_4.t));
		
		
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_15.s, ac0_37.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_37.s, ac0_15.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_37.s, -ac0_15.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_15.s, -ac0_37.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_15.s, ac0_37.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_37.s, ac0_15.t)); 
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_37.s, -ac0_15.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_15.s, -ac0_37.t));
		
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_15x0_9.s, ac0_37x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_37x0_9.s, ac0_15x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_37x0_9.s, -ac0_15x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_15x0_9.s, -ac0_37x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_15x0_9.s, ac0_37x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_37x0_9.s, ac0_15x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(-ac0_37x0_9.s, -ac0_15x0_9.t));
		blurredColor += getSampleWithBoundsCheck(vec2(ac0_15x0_9.s, -ac0_37x0_9.t));
	
	    blurredColor /= samples;
	    
	}

	gl_FragColor = mix(baseColor, blurredColor, blurAmount);
}

float getDepth(vec2 coord) {
	float depth = texture2D(sampler1, coord).x;
	float depth2 = texture2D(sampler2, coord).x;
	if (depth2 < 1.0) {
		depth = depth2;
	}
	
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float getCursorDepth(vec2 coord) {
    return 2.0 * near * far / (far + near - (2.0 * texture2D(sampler1, coord).x - 1.0) * (far - near));
}

vec4 getSampleWithBoundsCheck(vec2 offset) {
	vec2 coord = gl_TexCoord[0].st + offset;
	if (coord.s <= 1.0 && coord.s >= 0.0 && coord.t <= 1.0 && coord.t >= 0.0) {
		samples += 1.0;
		return texture2D(sampler0, coord);
	} else {
		return vec4(0.0);
	}
}